IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[P_GERA_RESSUPRIMENTO_DEPOSITO]') AND type in (N'P', N'PC'))
	DROP PROCEDURE [dbo].[P_GERA_RESSUPRIMENTO_DEPOSITO]
GO
  
/****** Object:  StoredProcedure [dbo].[P_GERA_RESSUPRIMENTO_DEPOSITO]    Script Date: 12/02/2016 9:05:49 AM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [dbo].[P_GERA_RESSUPRIMENTO_DEPOSITO](@LJ_ESPECIFICA INT=0, @PERC_FACEAMENTO MONEY=100)
AS
BEGIN 
	DECLARE @CD_CTR_DEPO INT
	DECLARE @CD_CTR_DEPO_AUX INT
	DECLARE @mensagemErro	VARCHAR(255),
			@severidadeErro INT,
			@estadoErro		INT;
/****************************************************************************************************************/
-- RESSUPRIMENTO CD PRINCIPAL
/****************************************************************************************************************/
	BEGIN TRY 
		DECLARE cDepo CURSOR FAST_FORWARD FOR 
		SELECT CD_CTR_DEPO
		FROM 
			PRC_FILIAL_DEPOSITO 
		ORDER BY CD_CTR_DEPO
		OPEN cDepo
		FETCH NEXT FROM cDepo INTO @CD_CTR_DEPO
		WHILE @@FETCH_STATUS=0
			BEGIN
			
				BEGIN TRY
					
					IF ((SELECT COUNT(1)
						FROM 
							PRC_FILIAL_DEPOSITO) > 1)
					BEGIN
						Print 'Atualizando pendencias de entrada e saída ' + convert(varchar, @CD_CTR_DEPO) + ' Time ' + convert(varchar,getdate(),108) ;
						
						EXECUTE P_EST_PROD_PENDENCIA_ENTRADA_RESSUPRIMENTO;
					END
				END TRY
				BEGIN CATCH
					Print 'Falha na atualizao da pendencia de entrada ' + convert(varchar, @CD_CTR_DEPO) + ' Time ' + convert(varchar,getdate(),108) ;
					SELECT	@mensagemErro = ERROR_MESSAGE(), 
							@severidadeErro = ERROR_SEVERITY(), 
							@estadoErro = ERROR_STATE();
					INSERT INTO ADM_ERRO (numero, severidade, estado, rotina, linha, mensagem, dtErro)
					SELECT
						ERROR_NUMBER() AS numero,
						@severidadeErro AS severidade,
						@estadoErro AS estado,
						ERROR_PROCEDURE() AS rotina,
						ERROR_LINE() AS linha,
						@mensagemErro AS mensagem,
						GETDATE() AS dtErro;

				END CATCH
				--paramentros : cd_emp,cd_Filial,opao de consulta, perc faceamento, cod deposito, cod depo auxiliar		
				
				Print 'Gerando ressuprimento do depsito ' + convert(varchar, @CD_CTR_DEPO) + ' Time ' + convert(varchar,getdate(),108) ;
				EXECUTE P_GERA_RESSUPRIMENTO_DEPOSITO_FILIAL 1,@LJ_ESPECIFICA,0,@PERC_FACEAMENTO,NULL,@CD_CTR_DEPO,NULL; 
				
				UPDATE EST_ARV_GRP_RESSUPRIMENTO SET FRESSUP_ULT_ATU= DBO.F_HOJE()   -5
				FETCH NEXT FROM cDepo INTO @CD_CTR_DEPO
			END
	END TRY
	BEGIN CATCH
		Print 'Falha na geracao ressuprimento do depsito  ' + convert(varchar, @CD_CTR_DEPO) + ' Time ' + convert(varchar,getdate(),108) ;
		--Registra erro na tabela de hist?rico de erros do banco Gestao
		--IF @@NESTLEVEL > 0  ROLLBACK TRANSACTION;----------------------------------------------------------------------------------
		SELECT	@mensagemErro = ERROR_MESSAGE(), 
				@severidadeErro = ERROR_SEVERITY(), 
				@estadoErro = ERROR_STATE();
		INSERT INTO ADM_ERRO (numero, severidade, estado, rotina, linha, mensagem, dtErro)
			SELECT
				ERROR_NUMBER() AS numero,
				@severidadeErro AS severidade,
				@estadoErro AS estado,
				ERROR_PROCEDURE() AS rotina,
				ERROR_LINE() AS linha,
				@mensagemErro AS mensagem,
				GETDATE() AS dtErro;
		RAISERROR (@mensagemErro, @severidadeErro, @estadoErro);
		RETURN -2;	
	END CATCH 
/****************************************************************************************************************/
-- ATUALIZACAO DAS PENDENCIAS DE ENTRADA
/****************************************************************************************************************/
	BEGIN TRY
		Print 'Atualizando a pendencia de entrada ' + convert(varchar, @CD_CTR_DEPO) + ' Time ' + convert(varchar,getdate(),108) ;
		EXEC P_EST_PROD_PENDENCIA_ENTRADA;
	END TRY
	BEGIN CATCH
		Print 'Falha na atualizao da pendencia de entrada ' + convert(varchar, @CD_CTR_DEPO) + ' Time ' + convert(varchar,getdate(),108) ;
		 --Registra erro na tabela de hist?rico de erros do banco Gestao
		--IF @@NESTLEVEL > 0 -- ROLLBACK TRANSACTION;----------------------------------------------------------------------------------
		SELECT	@mensagemErro = ERROR_MESSAGE(), 
				@severidadeErro = ERROR_SEVERITY(), 
				@estadoErro = ERROR_STATE();
		INSERT INTO ADM_ERRO (numero, severidade, estado, rotina, linha, mensagem, dtErro)
		SELECT
			ERROR_NUMBER() AS numero,
			@severidadeErro AS severidade,
			@estadoErro AS estado,
			ERROR_PROCEDURE() AS rotina,
			ERROR_LINE() AS linha,
			@mensagemErro AS mensagem,
			GETDATE() AS dtErro;
		--RAISERROR (@mensagemErro, @severidadeErro, @estadoErro);
		--RETURN -2;	
	END CATCH
/****************************************************************************************************************/
--RESSUPRIMENTO CDs AUXILIARES
/****************************************************************************************************************/
	BEGIN TRY
		-- Geracao dos resuprimentos de depositos auxiliares
		DECLARE cDepoAux CURSOR FAST_FORWARD FOR 
		SELECT 
			A.CD_CTR_DEPO,
			A.CD_CTR_DEPO_AUX 
		FROM 
			PRC_FILIAL_DEPOSITO_AUXILIAR A
			LEFT JOIN PRC_FILIAL_DEPOSITO D ON 
			A.CD_EMP			= D.CD_EMP AND
			A.CD_FILIAL_DEPO_AUX= D.CD_FILIAL 
		WHERE
			D.CD_EMP IS NULL 
		ORDER BY 
			A.CD_CTR_DEPO,
			A.CD_CTR_DEPO_AUX;

		OPEN cDepoAux
		FETCH NEXT FROM cDepoAux INTO @CD_CTR_DEPO,@CD_CTR_DEPO_AUX
		WHILE @@FETCH_STATUS=0
			BEGIN
				--paramentros : cd_emp,cd_Filial,opao de consulta, perc faceamento, cod deposito, cod depo auxiliar		
				Print 'Gerando ressuprimento do depsito auxiliar ' + convert(varchar, @CD_CTR_DEPO_AUX) + ' Time ' + convert(varchar,getdate(),108) ;
				EXECUTE P_GERA_RESSUPRIMENTO_DEPOSITO_FILIAL 1,@LJ_ESPECIFICA,0,@PERC_FACEAMENTO,NULL,@CD_CTR_DEPO,@CD_CTR_DEPO_AUX; 
				UPDATE EST_ARV_GRP_RESSUPRIMENTO SET FRESSUP_ULT_ATU= DBO.F_HOJE()   -5
				FETCH NEXT FROM cDepoAux INTO @CD_CTR_DEPO,@CD_CTR_DEPO_AUX;
			END 
		PRINT 'Concluido.'
		CLOSE cDepo;
		DEALLOCATE cDepo;
		CLOSE cDepoAux;
		DEALLOCATE cDepoAux; 
	END TRY ---------------------------------------------------------------------------------------------------
	BEGIN CATCH  --Registra erro na tabela de hist?rico de erros do banco Gestao
		--IF @@NESTLEVEL > 0 -- ROLLBACK TRANSACTION;----------------------------------------------------------------------------------
		SELECT	@mensagemErro = ERROR_MESSAGE(), 
				@severidadeErro = ERROR_SEVERITY(), 
				@estadoErro = ERROR_STATE();
		INSERT INTO ADM_ERRO (numero, severidade, estado, rotina, linha, mensagem, dtErro)
			SELECT
				ERROR_NUMBER() AS numero,
				@severidadeErro AS severidade,
				@estadoErro AS estado,
				ERROR_PROCEDURE() AS rotina,
				ERROR_LINE() AS linha,
				@mensagemErro AS mensagem,
				GETDATE() AS dtErro;
		RAISERROR (@mensagemErro, @severidadeErro, @estadoErro);
		RETURN -2;	
	END CATCH
/****************************************************************************************************************/
-- FIM
/****************************************************************************************************************/
	RETURN
end

GO


